/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.recipe.helper.TagPreference;
import slimeknights.mantle.util.JsonHelper;

public abstract class ItemOutput
implements Supplier<class_1799> {
    @Override
    public abstract class_1799 get();

    public abstract JsonElement serialize();

    public static ItemOutput fromStack(class_1799 stack) {
        return new OfStack(stack);
    }

    public static ItemOutput fromItem(class_1935 item, int count) {
        return new OfItem(item.method_8389(), count);
    }

    public static ItemOutput fromItem(class_1935 item) {
        return ItemOutput.fromItem(item, 1);
    }

    public static ItemOutput fromTag(class_6862<class_1792> tag, int count) {
        return new OfTagPreference(tag, count);
    }

    public static ItemOutput fromJson(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return ItemOutput.fromItem((class_1935)class_3518.method_15256((JsonElement)element, (String)"item"));
        }
        if (!element.isJsonObject()) {
            throw new JsonSyntaxException("Invalid item output, must be a string or an object");
        }
        JsonObject json = element.getAsJsonObject();
        if (json.has("tag")) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)JsonHelper.getResourceLocation(json, "tag"));
            int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
            return ItemOutput.fromTag((class_6862<class_1792>)tag, count);
        }
        return ItemOutput.fromStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
    }

    public void write(class_2540 buffer) {
        buffer.method_10793(this.get());
    }

    public static ItemOutput read(class_2540 buffer) {
        return ItemOutput.fromStack(buffer.method_10819());
    }

    private static class OfStack
    extends ItemOutput {
        private final class_1799 stack;

        @Override
        public class_1799 get() {
            return this.stack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.stack.method_7909())).toString();
            int count = this.stack.method_7947();
            if (this.stack.method_7985() || count > 1) {
                class_2487 nbt;
                JsonObject jsonResult = new JsonObject();
                jsonResult.addProperty("item", itemName);
                if (count > 1) {
                    jsonResult.addProperty("count", (Number)count);
                }
                if ((nbt = this.stack.method_7969()) != null) {
                    jsonResult.addProperty("nbt", nbt.toString());
                }
                return jsonResult;
            }
            return new JsonPrimitive(itemName);
        }

        public OfStack(class_1799 stack) {
            this.stack = stack;
        }
    }

    private static class OfItem
    extends ItemOutput {
        private final class_1792 item;
        private final int count;
        private class_1799 cachedStack;

        @Override
        public class_1799 get() {
            if (this.cachedStack == null) {
                this.cachedStack = new class_1799((class_1935)this.item, this.count);
            }
            return this.cachedStack;
        }

        @Override
        public JsonElement serialize() {
            String itemName = Objects.requireNonNull(class_7923.field_41178.method_10221((Object)this.item)).toString();
            if (this.count > 1) {
                JsonObject json = new JsonObject();
                json.addProperty("item", itemName);
                json.addProperty("count", (Number)this.count);
                return json;
            }
            return new JsonPrimitive(itemName);
        }

        public OfItem(class_1792 item, int count) {
            this.item = item;
            this.count = count;
        }
    }

    private static class OfTagPreference
    extends ItemOutput {
        private final class_6862<class_1792> tag;
        private final int count;
        private class_1799 cachedResult = null;

        @Override
        public class_1799 get() {
            if (this.cachedResult == null) {
                this.cachedResult = TagPreference.getPreference(this.tag).map(item -> new class_1799((class_1935)item, this.count)).orElse(class_1799.field_8037);
            }
            return this.cachedResult;
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("tag", this.tag.comp_327().toString());
            if (this.count != 1) {
                json.addProperty("count", (Number)this.count);
            }
            return json;
        }

        public OfTagPreference(class_6862<class_1792> tag, int count) {
            this.tag = tag;
            this.count = count;
        }
    }
}

